/*
 * Decompiled with CFR 0.152.
 */
package scene.controllers;

import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxCellRenderer;
import graph.generator.Graph;
import graph.generator.GraphFunctions;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javax.imageio.ImageIO;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.compress.utils.Sets;
import org.jgrapht.ext.JGraphXAdapter;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;
import scene.controllers.EditTableClass;
import scene.controllers.LegendController;
import shared.Table;
import shared.Translation;

public class GraphController
implements Initializable {
    private static final String HIGHLIGHT_COLOR = "strokeColor=#f71616";
    @FXML
    private ImageView graphImageView;
    @FXML
    private TableView<EditTableClass> itemsTable;
    @FXML
    private TableView<EditTableClass> attributesTable;
    @FXML
    private BorderPane imagePane;
    @FXML
    private CheckBox useTags;
    @FXML
    private Button showButton;
    @FXML
    private Button saveButton;
    @FXML
    private Button removeHighlightBtn;
    private Stage legendStage;
    private LegendController legendController;
    private Table table;
    private Graph graph;
    private BufferedImage image;
    private String h_vertex;

    private void resetTable(TableView tableView) {
        tableView.setEditable(true);
        tableView.getColumns().clear();
        tableView.getItems().clear();
    }

    private void createGraphObject(Table table) {
        this.table = table;
        GraphFunctions.GFunction f = SetUtils.difference(table.getPossibleValues(), (Set)Sets.newHashSet((Object[])new Float[]{Float.valueOf(0.0f), Float.valueOf(1.0f)})).isEmpty() ? GraphFunctions.GFunction.CLASSIC : GraphFunctions.GFunction.IMPLY;
        this.graph = new Graph(table, f);
    }

    private JGraphXAdapter<String, DefaultEdge> highlightPath(SimpleDirectedGraph<String, DefaultEdge> simpleGraph) {
        JGraphXAdapter graphAdapter = new JGraphXAdapter(simpleGraph);
        if (this.h_vertex == null) {
            return graphAdapter;
        }
        HashMap edgeToCellMap = graphAdapter.getEdgeToCellMap();
        HashMap vertexToCellMap = graphAdapter.getVertexToCellMap();
        HashMap edgeToHighlight = new HashMap();
        HashMap vertexToHighlight = new HashMap();
        this.graph.getColoredNodes(this.h_vertex).forEach(n -> {
            mxICell cfr_ignored_0 = (mxICell)vertexToHighlight.put(n.toTag(this.useTags.isSelected()), vertexToCellMap.get(n.toTag(this.useTags.isSelected())));
        });
        this.graph.getColoredEdges(this.h_vertex).forEach(e -> {
            boolean b = this.useTags.isSelected();
            DefaultEdge defaultEdge = (DefaultEdge)simpleGraph.getEdge((Object)e.getN1().toTag(b), (Object)e.getN2().toTag(b));
            edgeToHighlight.put(defaultEdge, edgeToCellMap.get(defaultEdge));
        });
        graphAdapter.setCellStyle(HIGHLIGHT_COLOR, vertexToHighlight.values().toArray());
        graphAdapter.setCellStyle(HIGHLIGHT_COLOR, edgeToHighlight.values().toArray());
        return graphAdapter;
    }

    public void createAndDrawGraph(Table table) {
        this.createGraphObject(table);
        ObservableList values = FXCollections.observableArrayList();
        table.getItemsList().forEach(item -> values.add((Object)new EditTableClass((String)item, true)));
        this.createTable(this.itemsTable, (ObservableList<EditTableClass>)values, true);
        ObservableList values2 = FXCollections.observableArrayList();
        table.getAttributesList().forEach(attr -> values2.add((Object)new EditTableClass((String)attr, true)));
        this.createTable(this.attributesTable, (ObservableList<EditTableClass>)values2, false);
        this.h_vertex = null;
        this.draw();
    }

    private void draw() {
        SimpleDirectedGraph simpleGraph = new SimpleDirectedGraph(DefaultEdge.class);
        this.graph.getNodes().forEach(n -> simpleGraph.addVertex((Object)n.toTag(this.useTags.isSelected())));
        this.graph.getEdges().forEach(e -> simpleGraph.addEdge((Object)e.getN1().toTag(this.useTags.isSelected()), (Object)e.getN2().toTag(this.useTags.isSelected()), (Object)new EmptyEdge()));
        JGraphXAdapter<String, DefaultEdge> graphAdapter = this.highlightPath((SimpleDirectedGraph<String, DefaultEdge>)simpleGraph);
        mxHierarchicalLayout layout = new mxHierarchicalLayout(graphAdapter);
        layout.execute(graphAdapter.getDefaultParent());
        this.image = mxCellRenderer.createBufferedImage(graphAdapter, null, (double)2.0, (Color)Color.WHITE, (boolean)true, null);
        this.graphImageView.setImage((Image)SwingFXUtils.toFXImage((BufferedImage)this.image, null));
        this.graphImageView.setPreserveRatio(true);
        this.graphImageView.fitWidthProperty().bind((ObservableValue)this.imagePane.widthProperty().subtract(10.0));
        this.graphImageView.fitHeightProperty().bind((ObservableValue)this.imagePane.heightProperty().subtract(10.0));
    }

    private void createTable(TableView tmpTable, ObservableList<EditTableClass> values, final boolean isItem) {
        this.resetTable(tmpTable);
        TableColumn nameCol = new TableColumn("Name");
        nameCol.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        Callback<TableColumn<EditTableClass, String>, TableCell<EditTableClass, String>> nameFactory = new Callback<TableColumn<EditTableClass, String>, TableCell<EditTableClass, String>>(){

            public TableCell call(TableColumn<EditTableClass, String> param) {
                TableCell<EditTableClass, String> cell = new TableCell<EditTableClass, String>(){
                    final Button btn = new Button();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            EditTableClass e = (EditTableClass)this.getTableView().getItems().get(this.getIndex());
                            e.setButton(this.btn);
                            this.btn.setText(e.getName());
                            this.btn.setMaxWidth(Double.MAX_VALUE);
                            this.btn.setDisable(e.getEnabled() == false);
                            this.btn.setOnAction(event -> {
                                GraphController.this.h_vertex = e.getName();
                                GraphController.this.draw();
                            });
                            this.setGraphic((Node)this.btn);
                        }
                        this.setText(null);
                    }
                };
                return cell;
            }
        };
        nameCol.setCellFactory((Callback)nameFactory);
        nameCol.setStyle("-fx-alignment: CENTER;");
        TableColumn checkCol = new TableColumn("Enabled");
        checkCol.setCellValueFactory((Callback)new PropertyValueFactory("enabled"));
        Callback<TableColumn<EditTableClass, Boolean>, TableCell<EditTableClass, Boolean>> checkFactory = new Callback<TableColumn<EditTableClass, Boolean>, TableCell<EditTableClass, Boolean>>(){

            public TableCell call(TableColumn<EditTableClass, Boolean> param) {
                TableCell<EditTableClass, Boolean> cell = new TableCell<EditTableClass, Boolean>(){
                    final CheckBox cb = new CheckBox();

                    public void updateItem(Boolean item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            EditTableClass e = (EditTableClass)this.getTableView().getItems().get(this.getIndex());
                            this.cb.setSelected(e.getEnabled().booleanValue());
                            this.cb.setOnAction(event -> {
                                if (!this.cb.isSelected() && (isItem && GraphController.this.table.getUnlockedItemsList().size() == 1 || !isItem && GraphController.this.table.getUnlockedAttributesList().size() == 1)) {
                                    GraphController.this.displayCheckError();
                                    this.cb.setSelected(true);
                                    return;
                                }
                                e.setEnabled(this.cb.isSelected());
                                if (isItem) {
                                    GraphController.this.table.setItemLock(e.getName(), e.getEnabled());
                                } else {
                                    GraphController.this.table.setAttributeLock(e.getName(), e.getEnabled());
                                }
                                GraphController.this.createGraphObject(GraphController.this.table);
                                GraphController.this.draw();
                                GraphController.this.useTags.setSelected(false);
                                GraphController.this.actionTag();
                            });
                            this.setGraphic((Node)this.cb);
                        }
                        this.setText(null);
                    }
                };
                return cell;
            }
        };
        checkCol.setCellFactory((Callback)checkFactory);
        checkCol.setStyle("-fx-alignment: CENTER;");
        tmpTable.getColumns().addAll(new Object[]{nameCol, checkCol});
        tmpTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        tmpTable.setItems(values);
    }

    private void displayCheckError() {
        Alert dialog = new Alert(Alert.AlertType.ERROR);
        dialog.setTitle("Error");
        dialog.setContentText("Non \u00e8 possibile eseguire l'operazione");
        dialog.showAndWait();
    }

    public void showLegend() {
        this.legendStage.setTitle("Legend - Graph");
        this.legendStage.show();
    }

    public void actionTag() {
        if (this.useTags.isSelected()) {
            this.showButton.setDisable(false);
            this.draw();
            this.legendController.fillLegend((ObservableList<Translation>)FXCollections.observableArrayList(this.graph.getLegend()));
            this.showLegend();
        } else {
            this.showButton.setDisable(true);
            this.legendStage.hide();
            this.draw();
        }
    }

    public void onClose() {
        this.legendStage.hide();
        this.showButton.setDisable(true);
        this.useTags.setSelected(false);
    }

    public void saveFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Graph's Image");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("png file", new String[]{"*.png"}));
        fileChooser.setInitialFileName("Graph.png");
        Stage stage = (Stage)this.imagePane.getScene().getWindow();
        File file = fileChooser.showSaveDialog((Window)stage);
        if (file != null) {
            try {
                ImageIO.write((RenderedImage)this.image, "png", file);
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
            }
        }
    }

    public void removeHighlight() {
        this.h_vertex = null;
        this.draw();
    }

    public void initialize(URL location, ResourceBundle resources) {
        System.out.println("Initialize Graph Controller");
        this.imagePane.setMinHeight(100.0);
        this.imagePane.setMinWidth(100.0);
        try {
            FXMLLoader loader = new FXMLLoader();
            FileInputStream fxmlStream = new FileInputStream("fxml/LegendScene.fxml");
            VBox root = (VBox)loader.load((InputStream)fxmlStream);
            this.legendController = (LegendController)loader.getController();
            Scene scene = new Scene((Parent)root);
            this.legendStage = new Stage();
            this.legendStage.setScene(scene);
        }
        catch (IOException e) {
            System.err.println("LegendScene.fxml not found!");
        }
    }

    private class EmptyEdge
    extends DefaultEdge {
        private EmptyEdge() {
        }

        public String toString() {
            return "";
        }
    }
}

